/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.blockentity;

import com.mojang.datafixers.util.Pair;
import dev.lucaargolo.charta.block.CardTableBlock;
import dev.lucaargolo.charta.block.GameChairBlock;
import dev.lucaargolo.charta.block.SeatBlock;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.entity.SeatEntity;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardGames;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameSlot;
import dev.lucaargolo.charta.item.CardDeckItem;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.network.GameSlotCompletePayload;
import dev.lucaargolo.charta.network.GameSlotPositionPayload;
import dev.lucaargolo.charta.network.GameSlotResetPayload;
import dev.lucaargolo.charta.network.GameStartPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class CardTableBlockEntity
extends class_2586 {
    public static final int TABLE_WIDTH = 160;
    public static final int TABLE_HEIGHT = 160;
    private static final Predicate<Vector2i> PY = pos -> pos.x == 0 && pos.y > 0;
    private static final Predicate<Vector2i> PX_PY = pos -> pos.x > 0 && pos.y > 0;
    private static final Predicate<Vector2i> PX = pos -> pos.x > 0 && pos.y == 0;
    private static final Predicate<Vector2i> PX_NY = pos -> pos.x > 0 && pos.y < 0;
    private static final Predicate<Vector2i> NY = pos -> pos.x == 0 && pos.y < 0;
    private static final Predicate<Vector2i> NX_XY = pos -> pos.x < 0 && pos.y < 0;
    private static final Predicate<Vector2i> NX = pos -> pos.x < 0 && pos.y == 0;
    private static final Predicate<Vector2i> NX_PY = pos -> pos.x < 0 && pos.y > 0;
    private static final Predicate<Vector2i>[] PREDICATES = new Predicate[]{PY, PX_PY, PX, PX_NY, NY, NX_XY, NX, NX_PY};
    private final List<GameSlot> trackedSlots = new ArrayList<GameSlot>();
    private final Set<Integer> dirtySlotCards = new HashSet<Integer>();
    private final Set<Integer> dirtySlotPositions = new HashSet<Integer>();
    private class_1799 deckStack = class_1799.field_8037;
    public Vector2f centerOffset = new Vector2f();
    @Nullable
    private CardGame<?> game = null;
    private int age = 0;
    public boolean playersDirty = true;

    public CardTableBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntityTypes.CARD_TABLE, pos, blockState);
    }

    @Nullable
    public CardDeck getDeck() {
        return CardDeckItem.getDeck(this.deckStack);
    }

    @Nullable
    public CardGame<?> getGame() {
        return this.game;
    }

    public class_2561 startGame(@Nullable class_2960 gameId, byte[] options) {
        CardDeck deck = this.getDeck();
        if (deck != null) {
            if (gameId != null) {
                List<CardPlayer> players = this.getOrderedPlayers();
                CardGames.Factory<?> factory = CardGames.getGame(gameId);
                if (factory != null) {
                    Object game = factory.create(players, this.getDeck());
                    ((CardGame)game).setRawOptions(options);
                    if (CardGame.canPlayGame(game, this.getDeck())) {
                        if (players.size() >= ((CardGame)game).getMinPlayers()) {
                            if (players.size() <= ((CardGame)game).getMaxPlayers()) {
                                class_1309 entity;
                                CardTableBlockEntity.sendToPlayersTrackingChunk((class_3218)this.field_11863, new class_1923(this.field_11867), new GameSlotResetPayload(this.field_11867));
                                for (CardPlayer player : players) {
                                    entity = player.getEntity();
                                    if (!(entity instanceof class_3222)) continue;
                                    class_3222 serverPlayer = (class_3222)entity;
                                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new GameStartPayload());
                                }
                                this.resetSlots();
                                this.game = game;
                                this.game.startGame();
                                this.game.runGame();
                                for (GameSlot slot : this.game.getSlots()) {
                                    slot.setX(slot.getX() + this.centerOffset.x * 160.0f);
                                    slot.setY(slot.getY() + this.centerOffset.y * 160.0f);
                                    slot.setParent(this);
                                    this.addSlot(slot);
                                }
                                for (CardPlayer player : players) {
                                    entity = player.getEntity();
                                    if (entity != null) {
                                        Vector3f offset = entity.method_19538().method_1023((double)this.field_11867.method_10263() + 0.5, entity.method_23318(), (double)this.field_11867.method_10260() + 0.5).method_46409();
                                        class_2350 direction = GameChairBlock.getSeatedDirection(entity);
                                        if (direction != null) {
                                            float angle = switch (direction) {
                                                case class_2350.field_11034 -> 90.0f;
                                                case class_2350.field_11035 -> 180.0f;
                                                case class_2350.field_11039 -> 270.0f;
                                                default -> 0.0f;
                                            };
                                            float x = switch (direction) {
                                                case class_2350.field_11043 -> 40.0f + 160.0f * offset.x;
                                                case class_2350.field_11034 -> -147.5f + 160.0f * (offset.x + 2.0f);
                                                case class_2350.field_11035 -> 120.0f + 160.0f * offset.x;
                                                case class_2350.field_11039 -> 307.5f + 160.0f * (offset.x - 2.0f);
                                                default -> 0.0f;
                                            };
                                            float y = switch (direction) {
                                                case class_2350.field_11043 -> -147.5f - 160.0f * (offset.z - 2.0f);
                                                case class_2350.field_11034 -> 120.0f - 160.0f * offset.z;
                                                case class_2350.field_11035 -> 307.5f - 160.0f * (offset.z + 2.0f);
                                                case class_2350.field_11039 -> 12.5f - 160.0f * offset.z + 27.5f;
                                                default -> 0.0f;
                                            };
                                            GameSlot slot = ((CardGame)game).getCensoredHand(player);
                                            slot.setX(x);
                                            slot.setY(y);
                                            slot.setAngle(angle);
                                            slot.setStackDirection(direction.method_10170());
                                            slot.setParent(this);
                                            slot.setIndex(this.getSlotCount());
                                            this.addSlot(slot);
                                        }
                                    }
                                    player.openScreen(this.game, this.field_11867, deck);
                                }
                                return class_2561.method_43471((String)"message.charta.game_started").method_27692(class_124.field_1060);
                            }
                            this.game = null;
                            return class_2561.method_43469((String)"message.charta.too_many_players", (Object[])new Object[]{((CardGame)game).getMaxPlayers()}).method_27692(class_124.field_1061);
                        }
                        this.game = null;
                        return class_2561.method_43469((String)"message.charta.not_enough_players", (Object[])new Object[]{((CardGame)game).getMinPlayers()}).method_27692(class_124.field_1061);
                    }
                    this.game = null;
                    return class_2561.method_43471((String)"message.charta.cant_play_deck").method_27692(class_124.field_1061);
                }
                this.game = null;
                return class_2561.method_43471((String)"message.charta.table_unknown_game").method_27692(class_124.field_1061);
            }
            this.game = null;
            return class_2561.method_43471((String)"message.charta.table_no_game").method_27692(class_124.field_1061);
        }
        this.game = null;
        return class_2561.method_43471((String)"message.charta.table_no_deck").method_27692(class_124.field_1061);
    }

    protected void method_11007(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (!this.deckStack.method_7960()) {
            tag.method_10566("deckStack", this.deckStack.method_57358(registries));
        } else {
            tag.method_10566("deckStack", (class_2520)new class_2487());
        }
        tag.method_10548("centerOffsetX", this.centerOffset.x);
        tag.method_10548("centerOffsetY", this.centerOffset.y);
    }

    protected void method_11014(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        if (tag.method_10545("deckStack")) {
            class_2487 compoundTag;
            class_2520 deckTag = tag.method_10580("deckStack");
            if (deckTag instanceof class_2487 && !(compoundTag = (class_2487)deckTag).method_10541().isEmpty()) {
                class_1799.method_57360((class_7225.class_7874)registries, (class_2520)deckTag).ifPresentOrElse(this::setDeckStack, () -> this.setDeckStack(class_1799.field_8037));
            } else {
                this.setDeckStack(class_1799.field_8037);
            }
        }
        this.centerOffset.x = tag.method_10583("centerOffsetX");
        this.centerOffset.y = tag.method_10583("centerOffsetY");
    }

    @NotNull
    public class_2487 method_16887(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        this.method_11007(tag, registries);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_1799 getDeckStack() {
        return this.deckStack;
    }

    public void setDeckStack(class_1799 deckStack) {
        this.deckStack = deckStack;
        this.method_5431();
    }

    public GameSlot getSlot(int index) {
        return this.trackedSlots.get(index);
    }

    public void addSlot(GameSlot slot) {
        this.dirtySlotCards.add(this.getSlotCount());
        this.trackedSlots.add(slot);
    }

    public void setSlotDirty(int index, boolean cards) {
        if (cards) {
            this.dirtySlotCards.add(index);
        } else {
            this.dirtySlotPositions.add(index);
        }
    }

    public int getSlotCount() {
        return this.trackedSlots.size();
    }

    public void resetSlots() {
        this.trackedSlots.forEach(GameSlot::clear);
        this.trackedSlots.clear();
        this.dirtySlotCards.clear();
        this.dirtySlotPositions.clear();
    }

    public List<class_1309> getPlayers() {
        class_2680 state;
        class_2248 class_22482;
        ArrayList<class_1309> players = new ArrayList<class_1309>();
        if (this.field_11863 != null && (class_22482 = (state = this.field_11863.method_8320(this.field_11867)).method_26204()) instanceof CardTableBlock) {
            CardTableBlock cardTable = (CardTableBlock)class_22482;
            Set<class_2338> set = cardTable.getMultiblock((class_1936)this.field_11863, this.field_11867);
            HashSet<class_2338> chairs = new HashSet<class_2338>();
            for (class_2338 pos : set) {
                if (!set.contains(pos.method_10095())) {
                    chairs.add(pos.method_10095());
                }
                if (!set.contains(pos.method_10072())) {
                    chairs.add(pos.method_10072());
                }
                if (!set.contains(pos.method_10078())) {
                    chairs.add(pos.method_10078());
                }
                if (set.contains(pos.method_10067())) continue;
                chairs.add(pos.method_10067());
            }
            for (class_2338 pos : chairs) {
                Object e;
                List passengers;
                List seats;
                class_2680 chairState = this.field_11863.method_8320(pos);
                if (!(chairState.method_26204() instanceof GameChairBlock) || !set.contains(pos.method_10093((class_2350)chairState.method_11654((class_2769)GameChairBlock.FACING))) || !SeatBlock.isSeatOccupied(this.field_11863, pos) || (seats = this.field_11863.method_18467(SeatEntity.class, new class_238(pos))).isEmpty() || (passengers = ((SeatEntity)((Object)seats.getFirst())).method_5685()).isEmpty() || !((e = passengers.getFirst()) instanceof class_1309)) continue;
                class_1309 entity = (class_1309)e;
                players.add(entity);
            }
        }
        return players;
    }

    private List<CardPlayer> getOrderedPlayers() {
        List<class_1309> players = this.getPlayers();
        if (players.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList entries = new LinkedList();
        class_243 center = this.field_11867.method_46558();
        players.forEach(player -> {
            Vector2i pos = new Vector2i(class_3532.method_15357((double)((player.method_23317() - center.field_1352) * 2.0)), class_3532.method_15357((double)((player.method_23321() - center.field_1350) * 2.0)));
            entries.add(new Pair((Object)pos, (Object)((LivingEntityMixed)player).charta_getCardPlayer()));
        });
        Collections.shuffle(entries);
        Pair firstEntry = (Pair)entries.getFirst();
        Vector2i firstPos = (Vector2i)firstEntry.getFirst();
        int firstQuadrant = CardTableBlockEntity.getQuadrant(firstPos);
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int i = 0; i < PREDICATES.length; ++i) {
            order.add((firstQuadrant + i) % PREDICATES.length);
        }
        entries.sort((a, b) -> {
            int bq;
            Vector2i va = (Vector2i)a.getFirst();
            Vector2i vb = (Vector2i)b.getFirst();
            int aq = CardTableBlockEntity.getQuadrant(va);
            if (aq == (bq = CardTableBlockEntity.getQuadrant(vb))) {
                return switch (aq) {
                    case 0 -> Integer.compare(vb.y, va.y);
                    case 1 -> {
                        if (vb.y != va.y) {
                            yield Integer.compare(vb.y, va.y);
                        }
                        yield Integer.compare(va.x, vb.x);
                    }
                    case 2 -> Integer.compare(vb.x, va.x);
                    case 3 -> {
                        if (vb.x != va.x) {
                            yield Integer.compare(vb.x, va.x);
                        }
                        yield Integer.compare(vb.y, va.y);
                    }
                    case 4 -> Integer.compare(va.y, vb.y);
                    case 5 -> {
                        if (va.y != vb.y) {
                            yield Integer.compare(va.y, vb.y);
                        }
                        yield Integer.compare(vb.x, va.x);
                    }
                    case 6 -> Integer.compare(va.x, vb.x);
                    case 7 -> {
                        if (va.x != vb.x) {
                            yield Integer.compare(va.x, vb.x);
                        }
                        yield Integer.compare(va.y, vb.y);
                    }
                    default -> 0;
                };
            }
            return Integer.compare(order.indexOf(aq), order.indexOf(bq));
        });
        return entries.stream().map(Pair::getSecond).toList().reversed();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CardTableBlockEntity blockEntity) {
        GameSlot slot;
        int index;
        Iterator<Integer> updateIterator = blockEntity.dirtySlotCards.iterator();
        while (updateIterator.hasNext()) {
            index = updateIterator.next();
            slot = blockEntity.trackedSlots.get(index);
            CardTableBlockEntity.sendToPlayersTrackingChunk((class_3218)level, new class_1923(pos), new GameSlotCompletePayload(pos, index, slot));
            blockEntity.dirtySlotPositions.remove(index);
            updateIterator.remove();
        }
        updateIterator = blockEntity.dirtySlotPositions.iterator();
        while (updateIterator.hasNext()) {
            index = updateIterator.next();
            slot = blockEntity.trackedSlots.get(index);
            CardTableBlockEntity.sendToPlayersTrackingChunk((class_3218)level, new class_1923(pos), new GameSlotPositionPayload(pos, index, slot.getX(), slot.getY(), slot.getZ(), slot.getAngle()));
            updateIterator.remove();
        }
        if (!((Boolean)state.method_11654((class_2769)CardTableBlock.CLOTH)).booleanValue() && !blockEntity.getDeckStack().method_7960()) {
            class_243 c = pos.method_46558();
            class_1264.method_5449((class_1937)level, (double)c.field_1352, (double)c.field_1351, (double)c.field_1350, (class_1799)blockEntity.getDeckStack());
            blockEntity.setDeckStack(class_1799.field_8037);
            level.method_8413(pos, state, state, 3);
        }
        if (blockEntity.game != null) {
            CardGame<?> game = blockEntity.game;
            if (!game.isGameOver()) {
                if (blockEntity.age++ % 100 == 0 || blockEntity.playersDirty) {
                    List<CardPlayer> players = blockEntity.getOrderedPlayers();
                    if (!players.containsAll(game.getPlayers())) {
                        game.endGame();
                    }
                    blockEntity.playersDirty = false;
                }
                game.tick();
            } else {
                CardTableBlockEntity.sendToPlayersTrackingChunk((class_3218)level, new class_1923(pos), new GameSlotResetPayload(pos));
                blockEntity.resetSlots();
                blockEntity.game = null;
            }
        }
    }

    private static int getQuadrant(Vector2i pos) {
        int quadrant = 0;
        for (int i = 0; i < PREDICATES.length; ++i) {
            if (!PREDICATES[i].test(pos)) continue;
            quadrant = i;
            break;
        }
        return quadrant;
    }

    private static void sendToPlayersTrackingChunk(class_3218 level, class_1923 chunkPos, class_8710 payload) {
        for (class_3222 player : level.method_14178().field_17254.method_17210(chunkPos, false)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }
}

